A Feature-Integration Theory of Attention

Cognitive Psychology 12, 97–136 (1980)

Anne M. Treisman (University of British Columbia)
Garry Gelade (Oxford University)

Copyright © 1980 by Academic Press, Inc. All rights reserved.

Summary

A new hypothesis about the role of focused attention is proposed. The feature‑integration theory of attention suggests that attention must be directed serially to each stimulus in a display whenever conjunctions of more than one separable feature are needed to characterize or distinguish the possible objects presented. Predictions were tested across paradigms—visual search, texture segregation, identification/localization—using separable dimensions (shape, color) and local elements (lines, curves). Results generally support the hypothesis, offering criteria for distinguishing separable from integral features and a rationale for predicting which tasks will show attention limits.

Introduction

The subjective immediacy of seeing coherent objects belies underlying processing stages. Physiological evidence indicates early analysis by specialized populations responsive to orientation, color, spatial frequency, motion, mapped across distinct brain areas. Against Gestalt claims that wholes precede parts, we propose that features come first: features are registered early, automatically, and in parallel; object identification occurs later and requires focused attention.

The feature‑integration theory assumes the visual scene is initially coded along separable dimensions (color, orientation, spatial frequency, brightness, motion). Correct synthesis requires serial focal attention to stimulus locations; any features within the same attentional fixation are integrated into a single object. Focal attention acts as the “glue” integrating separable features. Compound objects, once correctly registered, persist as integrated representations; with memory decay or interference, features may float free or recombine into illusory conjunctions.

Without focused attention, features cannot be related. Phenomenologically, unattended regions are not empty; top‑down constraints bind unattended features into plausible couplings (e.g., preventing a blue sun in a yellow sky). Absent effective constraints, unattended features may combine randomly, yielding illusory conjunctions.

We define “dimension” as the range of variation analyzed by an independent perceptual subsystem; “feature” as a particular value on a dimension. Dimensions need not map uniquely to physical attributes; relational properties (e.g., intensity contrast) and higher‑order properties (symmetry, homogeneity) may be basic. Separable dimensions should be inferred empirically (Shepard, Garner). Our theory adds diagnostics: integral features conjoin automatically; separable features require attention for integration. In preattentive and divided attention tasks, separability manifests in distinct patterns.

We tested predictions across five phenomena:

1. Visual search: single‑feature targets should be detected in parallel (flat search slopes vs. display size), whereas conjunction targets require serial focal attention (linear slopes; positive slope ≈ ½ negative slope).

2. Texture segregation: should be driven by discontinuities in separable features, not by conjunctions.

3. Illusory conjunctions: when attention is prevented, unattended features float and recombine incorrectly.

4. Identity vs. location: feature identification can occur without localization; conjunction identification necessitates prior localization.

5. Interference from unattended stimuli: unattended inputs affect behavior via their features, not via their specific conjunctions.

We used color and form—strong candidates for separable dimensions—and local elements within letters.

Experiment I: Visual Search—Conjunction vs. Features and Practice Effects

Method

- Stimuli: White cards with stenciled colored letters in an area 14° × 8°. Letters 0.8° × 0.6°. Display sizes: 1, 5, 15, 30 items. Each card divided into eight regions to randomize target location.

- Distractors: T_brown and X_brown.

- Targets:

▫ Conjunction: T_green (in a field of T_brown and X_brown).

▫ Feature: either any blue letter (T_blue or X_blue) or an S (S_brown or S_green). Thus feature search required attention to both color and shape dimensions but not their conjunction.

- Procedure: Three blocks (128 trials each) per condition for six subjects; extended practice in conjunction for two subjects up to 13 blocks. Tachistoscopic presentation; RT measured. Positive/negative trials balanced. Errors repeated; dummy trial after errors excluded from data.

- Subjects: Six adults (Oxford Subject Panel).

Results

Mean RT vs. display size:

- Conjunction condition: RT increased linearly with display size; linear component explained >99% of variance. Positive slope ≈ 0.43 × negative slope, indicating serial self‑terminating search. Scanning rate ≈ 60 ms/item.

- Feature condition (positives): RT minimally affected by display size (slope ≈ 3.1 ms); significant nonlinearity; suggests parallel detection for positives. Negatives: more linear (96% variance), slope smaller than conjunction negatives; positive/negative slope ratio ≈ 0.12.

- Errors: Low overall; higher false negatives in conjunction with largest display (8.2%).

- Display size 1: Conjunction and feature RTs similar; difficulty emerges only with multiple items.

- Practice (conjunction): Across 13 blocks, slopes and intercepts decreased initially (up to block 7), then stabilized; linearity maintained (>0.97). No transition to parallel search, suggesting difficulty of unitizing color–shape conjunctions via practice under these stimuli and training.

Discussion

Single‑feature targets are detected in parallel; conjunction targets require serial focal attention to integrate features. Positive/negative asymmetries indicate different processes: automatic detection of features when present; scanning tendencies for negatives. Extended practice did not unitize the conjunction (no parallelization), implying constraints on unitization across dimensions like color and shape.

Experiment II: Conjunction Search Rate Depends on Feature Discriminability

Method

- Displays: Regular matrices (2×2, 4×4, 6×6); mean eccentricity matched (~4.3°).

- Conditions:

▫ Easy: Target O_red among O_green and N_red (maximal feature separability).

▫ Difficult: Target T_green among X_green and T_blue (low separability; green and blue chosen to be similar).

- Subjects: Six volunteers; test–retest.

Results

All RT vs. display size functions linear (>99.8% variance). Positive/negative slope ratios ≈ 0.52 (easy) and 0.60 (difficult). Scanning rates ≈ 20.5 ms/item (easy positives) vs. 55.1 ms/item (difficult positives). Intercepts similar. Errors higher in difficult condition; especially false negatives in large displays.

Discussion

Conjunction search remains serial with slope ≈ 2:1 (neg:pos), but the per‑item rate depends on discriminability of component features. Regular spatial arrangement does not alter seriality; difficulty reflects integration, not incidental layout.

Experiment III: Central Similarity Does Not Explain Conjunction Effects

Method

- Unidimensional stimuli: Black ellipses varying in size; targets either intermediate (between two distractors) or disjunctive (either large or small).

- Procedure: As Experiment I, three blocks per condition.

Results

RT vs. display size functions were negatively accelerated (nonlinear), especially for intermediate positives. Intermediate negatives had steeper slopes than large/small negatives. Positive detection did not require serial item checking.

Discussion

Conjunction difficulty is not reducible to “centrality” (similarity to both distractor types). Unidimensional difficult searches can be slow yet proceed via parallel processing with serial fixations (foveation) rather than serial item decisions. This dissociates serial focal integration from serial eye movements.

Experiment IV: Letters—Conjunction of Local Elements vs. Similarity

Method

- Targets/distractors (two sets):

▫ Conjunction sets: R among P and Q (R/PQ); T among Z and I (T/ZI). Illusory conjunctions possible: P+Q could mimic R; Z+I could mimic T.

▫ Similarity controls: R among P and B (R/PB); T among I and Y (T/IY). Greater item similarity but no feature interchange yields target.

- Single‑distractor controls: R in Qs vs. R in Bs; T in Zs vs. T in Ys.

- Heterogeneity control: T in P/Q (T/PQ) compared to T/IY.

- Subjects: Six in main; additional for heterogeneity.

Results

- Conjunction conditions: Linear RT vs. display size; positive slopes ≈ half negatives (serial self‑termination).

- Similarity conditions: Positive nonlinearity; smaller slope ratio (~0.26), akin to feature searches.

- Single‑distractor controls: Similarity costs reversed—R/B and T/Y slower than R/Q and T/Z (t(7)=3.69, p<.02).

- Heterogeneity control: T/PQ resembled T/IY; heterogeneity does not explain conjunction effect.

- Pilot sets (N/VH vs. N/VW; E/FL vs. E/FT; Q/OK vs. Q/OG) supported pattern: conjunction searches slower and more linear than similarity.

Discussion

Serial search arises when local elements are separable features that can recombine into illusory conjunctions; mere similarity does not induce seriality. Letters—despite familiarity—are decomposed into local features requiring focal integration when conjunction errors are possible. This challenges accounts relying solely on item confusability (Gardner, Estes) and aligns partially with perturbation models (Wolford), but the observed latency linearities under unlimited exposure necessitate focal integration rather than memory perturbation alone.

Experiment V: Texture Segregation—Features vs. Conjunctions (Color/Shape)

Method

- 5×5 matrices of red/blue O and V. Imaginary boundary splits the matrix (horizontal/vertical).

- Conditions:

▫ Color boundary: all red vs. all blue (with shapes mixed).

▫ Shape boundary: all O vs. all V (with colors mixed).

▫ Conjunction boundary: O_red + V_blue vs. V_red + O_blue.

- Task: Sort cards by boundary orientation; line‑only pack as control.

Results

Feature packs yielded sorting times near line control; conjunction pack substantially slower (face‑up: +430 ms/card; face‑down: similar increment). Strategy in conjunction pack involved scanning for a single conjunction (e.g., O_red) to infer boundary.

Discussion

Preattentive texture segmentation operates on separable features; conjunctions fail to define boundaries without serial focal attention. Estimated scanning aligns with per‑item rates from conjunction search.

Experiment VI: Texture Segregation with Disjunctive Feature Boundaries

Method

- Disjunctive feature pack: One side O_red + V_green, other side O_green + V_red. Boundary is defined by a disjunction (half differ by shape, half by color).

- Compared to line and conjunction packs.

Results

Sorting times: line < disjunctive feature < conjunction, all significantly different. Disjunctive features slightly slower than single features but far faster than conjunctions.

Discussion

Heterogeneity and attention to two dimensions do not account for conjunction difficulty; any feature‑level discriminability—even disjunctive—supports preattentive segregation, whereas conjunctions do not.

Experiment VII: Texture Segregation—Letters

Method

- 5×5 matrices with letter pairs:

▫ Feature conditions: PO/RQ and FQ/EO (diagonal strokes present on one side only).

▫ Conjunction conditions: PQ/RO and FK/EX (no single feature discriminates across boundary).

- Task: Identify boundary orientation under tachistoscopic presentation.

Results

Five of six subjects: feature conditions faster than conjunctions; errors comparable. One subject showed no feature advantage, likely using letter‑level strategy exclusively.

Discussion

Consistent with separable local features mediating segregation; conjunction-only displays lack preattentive boundary cues. Strategy choice can suppress feature use.

Experiments VIII & IX: Identity–Location Dependency

Method

- Displays: Two rows of six colored letters (X_brown, O_blue, O_brown, X_blue; one target in eight inner positions).

- Feature condition: targets were H (pink or blue) or orange color (in X or O).

- Conjunction condition: X_pink or O_blue.

- Responses: identity and location recorded. Exposure durations adjusted:

▫ Experiment VIII: durations set to yield ~80% identity correct in each condition (features ≈ 65 ms; conjunctions ≈ 414 ms).

▫ Experiment IX: matched exposure durations within sessions (~117 ms mean), ensuring analyzable errors.

Results

Conditional probabilities of correct identity given location response:

Experiment

Condition

Correct Loc

Adjacent Loc

Distant Loc

Overall

VIII

Conjunction

0.930

0.723

0.500

0.793

VIII

Feature

0.897

0.821

0.678

0.786

IX

Conjunction

0.840

0.582

0.453

0.587

IX

Feature

0.979

0.925

0.748

0.916

Location given wrong identity was at or near chance (using mirror‑image control) for both conditions (minor exception in VIII features).

Discussion

Conjunction identification depends on localization: when location is wrong by more than adjacent positions, identity is at chance. Adjacent errors can co‑occur with correct identification if the attentional focus includes neighboring items sharing one feature and differing on the other. Feature identity can be correctly registered without accurate localization; feature localization itself is a conjunction (feature × location) and requires focal attention. These findings align with the theory’s separate feature maps and later spatial binding.

General Conclusions

Across converging paradigms:

- Separable features are registered early, automatically, in parallel (modulated by acuity and discriminability); they mediate texture segregation and can be identified without localization; unattended features can produce behavioral effects and illusory conjunctions.

- Conjunctions require focal attention directed serially; they do not mediate texture segregation; identification implies localization; search yields linear RT increases with display size and ≈2:1 negative/positive slope ratio.

Thus, the distinction between features and conjunctions underlies both parallel detection and perceptual grouping. Attention operates like a spotlight/zoom lens: it can focus narrowly to integrate features into objects or spread across groups sharing a feature. Illusory conjunctions occur outside the spotlight or within it when multiple interchangeable features co‑occupy the focus; they do not cross its boundary. Displays structured into homogeneous groups can convert conjunction searches into sequential feature searches with only a few attentional deployments.

Serial integration cannot be replaced by two parallel feature filters across interleaved items because selective attention to sets (e.g., “all red items”) is mediated by spatial selection; constraints likely govern the number/geometry of simultaneous attentional foci (convexity, continuity, symmetry).

In everyday perception, rich object experience is sustained by feature maps and top‑down expectations; focal attention refines binding where redundancy is low or precision is required (e.g., proofreading). Clinical syndromes (visual agnosia) may reflect impairments in feature integration, consistent with historical accounts of “disjunctive agnosia.”

Two routes to object awareness:

1. Focal attention serially integrates features within a spatiotemporal focus.

2. Top‑down processing predicts objects and matches disjunctive features without verifying exact conjunctions; errors arise in misleading contexts.

References

Biederman, I., Glass, A. L., & Stacy, E. W. (1973). Searching for objects in real‑world scenes. Journal of Experimental Psychology, 97, 22–27.

Corteen, R. S., & Wood, B. (1972). Autonomic responses to shock‑associated words in an unattended channel. Journal of Experimental Psychology, 94, 308–313.

Critchley, M. (1964). The problem of visual agnosia. Journal of Neurological Sciences, 1, 274–290.

Cutting, J. E. (1976). Auditory and linguistic processes in speech perception: Inferences from six fusions in dichotic listening. Psychological Review, 83, 114–140.

De Valois, R. L., & De Valois, K. K. (1975). Neural coding of color. In E. C. Carterette & M. P. Friedman (Eds.), Handbook of Perception (Vol. V, pp. 117–166). New York: Academic Press.

Efron, R., & Yund, E. W. (1974). Dichotic competition of simultaneous tone bursts of different frequency. Neuropsychologia, 12, 149–156.

Eriksen, C. W. W., & Hoffman, J. E. (1972). Temporal and spatial characteristics of selective encoding from visual displays. Perception and Psychophysics, 12, 201–204.

Estes, W. K. (1972). Interactions of signal and background variables in visual processing. Perception and Psychophysics, 12, 278–286.

Fisher, D. F., Monty, R. A., & Glucksberg, S. (1969). Visual confusion matrices: fact or artifact. Journal of Psychology, 71, 111–125.

Forster, P. M., & Govier, E. (1978). Discrimination without awareness. Quarterly Journal of Experimental Psychology, 30, 289–296.

Gardner, G. T. (1973). Evidence for independent parallel channels in tachistoscopic perception. Cognitive Psychology, 4, 130–155.

Gardner, H. (1975). The shattered mind. New York: Alfred A. Knopf.

Garner, W. R. (1974). The processing of information and structure. Potomac, MD: Lawrence Erlbaum.

Gibson, E. J. (1971). Perceptual learning and the theory of word perception. Cognitive Psychology, 2, 351–368.

Hecaen, H., & Albert, M. L. (1978). Human neuropsychology. New York: Wiley.

Hodge, D. C. (1962). Legibility of a uniform stroke width alphabet: I. Relative legibility of upper and lower case letters. Journal of Engineering Psychology, 1, 34–46.

Jonides, J., & Gleitman, H. (1972). A conceptual category effect in visual search: 0 as letter or as digit. Perception and Psychophysics, 12, 457–460.

Julesz, B. (1975). Experiments in the visual perception of texture. Scientific American, 232, 34–43.

Kahneman, D., & Henik, A. (1977). Effects of visual grouping on immediate recall and selective attention. In S. Dornic (Ed.), Attention and Performance VI (pp. 307–332). Hillsdale, NJ: Lawrence Erlbaum.

LaBerge, D. (1973). Attention and the measurement of perceptual learning. Memory and Cognition, 1, 268–276.

Lawrence, D. H. (1971). Two studies of visual search for word targets with controlled rates of presentation. Perception and Psychophysics, 10, 85–89.

Lewis, J. L. (1970). Semantic processing of unattended messages using dichotic listening. Journal of Experimental Psychology, 85, 225–228.

Liepmann, H. (1908). Über die agnostischen Störungen. Neurologisches Zentralblatt, 27, 609–617.

Luria, A. R. (1972). The man with a shattered world. New York: Basic Books.

MacKay, D. G. (1973). Aspects of the theory of comprehension, memory and attention. Quarterly Journal of Experimental Psychology, 25, 22–40.

Monahan, J. S., & Lockhead, G. R. (1977). Identification of integral stimuli. Journal of Experimental Psychology: General, 106, 94–110.

Neisser, U. (1967). Cognitive psychology. New York: Appleton‑Century‑Crofts.

Neisser, U. (1977). Cognition and reality. San Francisco: Freeman.

Neisser, U., Novick, R., & Lazar, R. (1963). Searching for ten targets simultaneously. Perceptual and Motor Skills, 17, 955–961.

Pew, R. W., & Gardner, G. T. (Unpublished; summarized in Fisher et al., 1969).

Posner, M. I. (1978). Chronometric explorations of mind. Hillsdale, NJ: Lawrence Erlbaum.

Rabbitt, P. M. A. (1967). Learning to ignore irrelevant information. British Journal of Psychology, 55, 403–414.

Rock, I., Halper, F., & Clayton, R. (1972). The perception and recognition of complex figures. Cognitive Psychology, 3, 655–673.

Shepard, R. N. (1964). Attention and the metric structure of the stimulus space. Journal of Mathematical Psychology, 1, 54–87.

Shiffrin, R. M., & Schneider, W. (1977). Controlled and automatic human information processing II. Psychological Review, 84, 127–190.

Townsend, J. T. (1971). Theoretical analysis of an alphabetic confusion matrix. Perception and Psychophysics, 9, 40–50.

Treisman, A. (1977). Focused attention in the perception and retrieval of multidimensional stimuli. Perception and Psychophysics, 22, 1–11.

Treisman, A. (1979). The psychological reality of levels of processing. In L. S. Cermak & F. I. M. Craik (Eds.), Levels of processing and human memory. Hillsdale, NJ: Lawrence Erlbaum.

Treisman, A., Squire, R., & Green, J. (1974). Semantic processing in dichotic listening? Memory and Cognition, 2, 641–646.

Treisman, A., Sykes, M., & Gelade, G. (1977). Selective attention and stimulus integration. In S. Dornic (Ed.), Attention and Performance VI (pp. 333–361). Hillsdale, NJ: Lawrence Erlbaum.

White, M. J. (1977). Identification and categorization in visual search. Memory and Cognition, 5, 648–657.

Wolford, G. (1975). Perturbation model for letter identification. Psychological Review, 82, 184–199.

Zeki, S. M. (1976). Functional organization of projections from striate to prestriate visual cortex in rhesus monkey. Cold Spring Harbor Symposia on Quantitative Biology, 15, 591–600.

Reference Note

- Julesz, B. (1978). Colloquium, Stanford University.
